def reset_results(
    student_id,
    course_lesson_id,
    delete_course_lesson_result=False,
    recalculate_journals=False,
):
    from ..models import CourseLessonResult
    from kelvin.scorm.models import Scorm, ScormResourceUserData
    from kelvin.result_stats.models import StudentCourseStat
    from kelvin.lesson_assignments.views import recalculate_studentcoursestat
    from kelvin.result_stats.tasks import calculate_course_journal, calculate_lesson_journal
    from kelvin.courses.models import CourseLessonLink

    course_lesson_link = CourseLessonLink.objects.all().select_related('course').get(id=course_lesson_id)

    deleted_data = {}

    scorms = Scorm.objects.filter(student_id=student_id, clesson_id=course_lesson_id)
    deleted_data['Scorm'] = [scorm.id for scorm in scorms]
    scorms.delete()

    scorms_resource_user_datas = ScormResourceUserData.objects.filter(
        student_id=student_id, clesson_id=course_lesson_id
    )
    deleted_data['ScormResourceUserData'] = [
        scorms_resource_user_data.id for scorms_resource_user_data in scorms_resource_user_datas
    ]
    scorms_resource_user_datas.delete()

    student_course_stats = StudentCourseStat.objects.filter(
        student_id=student_id, course=course_lesson_link.course
    )
    deleted_data['StudentCourseStat'] = [student_course_stat.id for student_course_stat in student_course_stats]
    student_course_stats.delete()

    recalculate_studentcoursestat(student_id=student_id, course_id=course_lesson_link.course_id)

    if delete_course_lesson_result:
        course_lesson_results = CourseLessonResult.objects.filter(
            summary__student_id=student_id, summary__clesson_id=course_lesson_id
        )
        deleted_data['CourseLessonResult'] = [course_lesson_result.id for course_lesson_result in course_lesson_results]
        course_lesson_results.delete()

    if recalculate_journals:
        calculate_lesson_journal(clesson_id=course_lesson_id)
        calculate_course_journal(course_id=course_lesson_link.course_id)

    return deleted_data
