from collections import OrderedDict

from django.conf import settings

from rest_framework.pagination import PageNumberPagination
from rest_framework.response import Response


class SiriusApiPaginator(PageNumberPagination):
    """
    Дефолтный пагинатор для API
    """
    page_size = settings.LMS_LIBRARY_PAGE_LIMIT
    page_size_query_param = 'limit'
    max_page_size = settings.LMS_LIBRARY_PAGE_LIMIT_MAX


class SiriusExportPaginator(SiriusApiPaginator):
    """
    Пагинатор API экспорта
    """
    page_size = settings.LMS_EXPORT_PAGE_LIMIT
    max_page_size = settings.LMS_EXPORT_PAGE_LIMIT_MAX

    def get_paginated_response(self, data):
        """
        Возвращает ответ с переопределенной структурой
        """
        return Response(OrderedDict([
            ('count', self.page.paginator.count),
            ('limit', self.page_size),
            ('page', self.page.number),
            ('results', data)
        ]))
