# -*- coding: utf-8 -*-
# Generated by Django 1.11.29 on 2021-11-08 10:10
from __future__ import unicode_literals

import django.db.models.deletion
import simple_history.models
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('scorm', '0010_ispring_data_qt'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalScorm',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date_created', models.DateTimeField(blank=True, editable=False, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(blank=True, editable=False, verbose_name='Date of change')),
                ('score_percent', models.IntegerField(blank=True, null=True, verbose_name='Процент баллов за scorm-курс')),
                ('passed', models.BooleanField(default=False, verbose_name='Признак завершенности scorm-курса')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical SCORM данные ученика в курсозанятии',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='HistoricalScormResourceUserData',
            fields=[
                ('id', models.IntegerField(auto_created=True, blank=True, db_index=True, verbose_name='ID')),
                ('date_created', models.DateTimeField(blank=True, editable=False, verbose_name='Creation date')),
                ('date_updated', models.DateTimeField(blank=True, editable=False, verbose_name='Date of change')),
                ('score_percent', models.IntegerField(blank=True, null=True, verbose_name='Процент баллов за scorm-курс')),
                ('passed', models.BooleanField(default=False, verbose_name='Признак завершенности scorm-курса')),
                ('resource_ref', models.CharField(max_length=255, verbose_name='Ресурс')),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical SCORM данные ученика в ресурсе scorm-курса',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.AddField(
            model_name='scorm',
            name='passed',
            field=models.BooleanField(default=False, verbose_name='Признак завершенности scorm-курса'),
        ),
        migrations.AddField(
            model_name='scorm',
            name='score_percent',
            field=models.IntegerField(blank=True, null=True, verbose_name='Процент баллов за scorm-курс'),
        ),
        migrations.AddField(
            model_name='scormresourceuserdata',
            name='passed',
            field=models.BooleanField(default=False, verbose_name='Признак завершенности scorm-курса'),
        ),
        migrations.AddField(
            model_name='scormresourceuserdata',
            name='score_percent',
            field=models.IntegerField(blank=True, null=True, verbose_name='Процент баллов за scorm-курс'),
        ),
    ]
