from builtins import object

from simple_history.models import HistoricalRecords

from django.conf import settings
from django.db import models
from django.utils.translation import ugettext_lazy as _

from kelvin.common.fields import JSONField
from kelvin.common.model_mixins import TimeStampMixin
from kelvin.courses.models import CourseLessonLink


class ScormBase(TimeStampMixin, models.Model):
    """
    Scorm user data in courselesson
    """
    data = JSONField(
        verbose_name=_('Данные'),
        default=dict,
    )
    clesson = models.ForeignKey(
        CourseLessonLink,
        verbose_name=_('Курсозанятие'),
    )
    student = models.ForeignKey(
        settings.AUTH_USER_MODEL,
        verbose_name=_('Ученик'),
    )
    ispring_suite_data = JSONField(
        verbose_name=_("Данные ISpring Suite"),
        default=dict,
    )
    score_percent = models.IntegerField(
        verbose_name=_('Процент баллов за scorm-курс'),
        null=True,
        blank=True,
    )
    passed = models.BooleanField(
        verbose_name=_("Признак завершенности scorm-курса"),
        default=False,
    )

    history = HistoricalRecords(excluded_fields=['data', 'clesson', 'student', 'ispring_suite_data'], inherit=True)

    class Meta(object):
        abstract = True


class Scorm(ScormBase):
    class Meta(ScormBase.Meta):
        unique_together = ('clesson', 'student')
        verbose_name = _('SCORM данные ученика в курсозанятии')
        verbose_name_plural = _('SCORM данные учеников в курсозанятиях')


class ScormResourceUserData(ScormBase):
    """
    Scorm resource user data in courselesson
    """
    resource_ref = models.CharField(_('Ресурс'), max_length=255)

    class Meta(Scorm.Meta):
        unique_together = ('clesson', 'student', 'resource_ref')
        verbose_name = _('SCORM данные ученика в ресурсе scorm-курса')
        verbose_name_plural = _('SCORM данные учеников в ресурсе scorm-курса')


class ScormISpringSuiteData(TimeStampMixin, models.Model):
    scorm = models.ForeignKey(to=Scorm)
    qt = models.TextField(blank=True, null=True)
    quiz_type = models.TextField(blank=True, null=True)
    max_score = models.TextField(blank=True, null=True)
    max_normalized_score = models.TextField(blank=True, null=True)
    time_limit = models.TextField(blank=True, null=True)
    passing_percent = models.TextField(blank=True, null=True)
    score = models.TextField(blank=True, null=True)
    percent = models.TextField(blank=True, null=True)
    time = models.TextField(blank=True, null=True)
    finish_timestamp = models.TextField(blank=True, null=True)
    passed = models.TextField(blank=True, null=True)


class ScormISpringSuiteQuestionsData(TimeStampMixin, models.Model):
    scorm = models.ForeignKey(to=Scorm)
    qt = models.TextField(blank=True, null=True)
    question_id = models.TextField(blank=True, null=True)
    question_type = models.TextField(blank=True, null=True)
    status = models.TextField(blank=True, null=True)
    evaluation_enabled = models.TextField(blank=True, null=True)
    max_points = models.TextField(blank=True, null=True)
    max_attempts = models.TextField(blank=True, null=True)
    awarded_points = models.TextField(blank=True, null=True)
    used_attempts = models.TextField(blank=True, null=True)
    direction = models.TextField(blank=True, null=True)
    feedback = models.TextField(blank=True, null=True)
    answers = models.TextField(blank=True, null=True)
    user_answer = models.TextField(blank=True, null=True)
    correct_answer = models.TextField(blank=True, null=True)
