from builtins import object

from rest_framework import serializers

from kelvin.scorm.models import Scorm, ScormResourceUserData


class ScormBaseSerializer(serializers.ModelSerializer):
    class Meta(object):
        model = Scorm
        fields = ('data',)

    def validate_data(self, value):
        """
        Check if `data` field is dict
        """
        if not isinstance(value, dict):
            raise serializers.ValidationError("Data must be dict")
        return value


class ScormSerializer(ScormBaseSerializer):
    """
    Scorm model serializer
    """
    class Meta(ScormBaseSerializer.Meta):
        model = Scorm


class ScormResourceUserDataSerializer(ScormBaseSerializer):
    """
    ScormResourceUserData model serializer
    """
    class Meta(ScormBaseSerializer.Meta):
        model = ScormResourceUserData


class ScormISpringSuiteDataSerializer(serializers.ModelSerializer):
    class Meta(object):
        model = Scorm
        fields = ('ispring_suite_data',)
