import xml.dom.minidom
import zipfile

from kelvin.resources.models import Resource
from kelvin.scorm.models import Scorm, ScormResourceUserData

MANIFEST_FILENAME = 'imsmanifest.xml'


def move_courses_pass_to_resource_pass():
    scorms = (
        Scorm.objects.filter(clesson__lesson__problems__markup__layout__0__content__type='scorm')
    )

    for scorm in scorms:
        problem = scorm.clesson.lesson.problems.first()

        if not problem:
            continue

        resource_id = problem.markup.get(
            'layout', [{}])[0].get('content', {}).get('options', {}).get('sco', {}).get('id')
        resource = Resource.objects.filter(id=resource_id).first()
        if not resource:
            continue

        z = zipfile.ZipFile(resource.file)
        z.extract(MANIFEST_FILENAME)

        doc = xml.dom.minidom.parse(MANIFEST_FILENAME)
        node = doc.documentElement
        resources = node.getElementsByTagName("resources")[0]

        resource_id = ''
        for resource in resources.childNodes:
            if resource.nodeType == resource.ELEMENT_NODE:
                resource_id = resource.getAttribute('identifier')
                break

        scorm_resource_user_data = ScormResourceUserData(
            data=scorm.data,
            clesson=scorm.clesson,
            student=scorm.student,
            resource_ref=resource_id
        )
        scorm_resource_user_data.save()
