from django.db import transaction

from ..ispring.parsers import parse_ispring_data, parse_question
from ..models import Scorm, ScormISpringSuiteData, ScormISpringSuiteQuestionsData

BULK_BATCH_SIZE_DEFAULT = 1000


@transaction.atomic()
def update_ispring_data(scorm: Scorm):
    ScormISpringSuiteData.objects.filter(scorm=scorm).delete()
    ScormISpringSuiteData.objects.bulk_create(
        objs=(
            ScormISpringSuiteData(
                scorm=scorm,
                qt=qt,
                **parse_ispring_data(ispring_suite_data_item)
            )
            for qt, ispring_suite_data_item in scorm.ispring_suite_data.items()
        ),
        batch_size=BULK_BATCH_SIZE_DEFAULT,
    )


@transaction.atomic()
def update_ispring_questions_data(scorm: Scorm):
    ScormISpringSuiteQuestionsData.objects.filter(scorm=scorm).delete()
    ScormISpringSuiteQuestionsData.objects.bulk_create(
        objs=(
            ScormISpringSuiteQuestionsData(
                scorm=scorm,
                qt=qt,
                **question_item,
            )
            for qt, ispring_suite_data_item in scorm.ispring_suite_data.items()
            for question_type, question
            in ispring_suite_data_item.get('dr', {}).get('quizReport', {}).get('questions', {}).items()
            for question_item in parse_question(question_type, question)
        ),
        batch_size=BULK_BATCH_SIZE_DEFAULT,
    )
