from django.db import transaction
from django.db.models.signals import post_save, pre_save
from django.dispatch import receiver

from .models import Scorm, ScormResourceUserData
from .tasks import (
    update_clesson_result_points_task_scorm, update_clesson_result_points_task_scorm_resource_user_data,
    update_ispring_data_task, update_ispring_questions_data_task,
)
from .utils import update_scorm_points


@receiver(signal=pre_save, sender=Scorm)
def scorm_pre_save_handler(instance, **kwargs):
    score_updated = update_scorm_points(scorm=instance)
    instance._score_updated = score_updated


@receiver(signal=post_save, sender=Scorm)
def scorm_post_save_handler(instance, **kwargs):
    def run_tasks(score_updated: bool):
        if score_updated:
            update_clesson_result_points_task_scorm.delay(instance.id)
        if instance.ispring_suite_data:
            update_ispring_data_task.delay(instance.id)
            update_ispring_questions_data_task.delay(instance.id)

    transaction.on_commit(lambda: run_tasks(score_updated=getattr(instance, '_score_updated', False)))


@receiver(signal=pre_save, sender=ScormResourceUserData)
def scorm_resource_user_data_pre_save_handler(instance, **kwargs):
    score_updated = update_scorm_points(scorm=instance)
    instance._score_updated = score_updated


@receiver(signal=post_save, sender=ScormResourceUserData)
def scorm_resource_user_data_post_save_handler(instance, **kwargs):
    if getattr(instance, '_score_updated', False):
        update_clesson_result_points_task_scorm_resource_user_data.delay(instance.id)
