from django.conf import settings

from kelvin.celery import app
from kelvin.common.decorators.celery_throttler import throttled_task
from kelvin.common.decorators.task_logger import logged_task
from kelvin.scorm.models import Scorm, ScormResourceUserData

from .services.update_ispring_data import update_ispring_data, update_ispring_questions_data
from .utils import update_clesson_result_points


@logged_task
@throttled_task(acks_late=True, bind=True, max_retries=10)
def update_clesson_result_points_task_scorm(self, scorm_id):
    scorm = Scorm.objects.filter(id=scorm_id).select_related('clesson', 'student').first()
    if scorm:
        update_clesson_result_points(scorm)
    else:
        raise self.retry(
            exc=Exception("Scorm with id %s not found" % scorm_id),
            countdown=settings.CELERY_DEFAULT_COUNTDOWN,
        )

@logged_task
@throttled_task(acks_late=True, bind=True, max_retries=10)
def update_clesson_result_points_task_scorm_resource_user_data(self, scorm_id):
    scorm_resource_user_data = (
        ScormResourceUserData.objects.filter(id=scorm_id).select_related('clesson', 'student').first()
    )
    if scorm_resource_user_data:
        update_clesson_result_points(scorm_resource_user_data)
    else:
        raise self.retry(
            exc=Exception("ScormResourceUserData with id %s not found" % scorm_id),
            countdown=settings.CELERY_DEFAULT_COUNTDOWN,
        )


@logged_task
@app.task(acks_late=True, bind=True, max_retries=10)
def update_ispring_data_task(self, scorm_id: int):
    scorm = Scorm.objects.filter(id=scorm_id).first()
    if scorm:
        update_ispring_data(scorm=scorm)
    else:
        raise self.retry(
            exc=Exception("Scorm with id %s not found" % scorm_id),
            countdown=settings.CELERY_DEFAULT_COUNTDOWN,
        )


@logged_task
@app.task(acks_late=True, bind=True, max_retries=10)
def update_ispring_questions_data_task(self, scorm_id: int):
    scorm = Scorm.objects.filter(id=scorm_id).first()
    if scorm:
        update_ispring_questions_data(scorm=scorm)
    else:
        raise self.retry(
            exc=Exception("Scorm with id %s not found" % scorm_id),
            countdown=settings.CELERY_DEFAULT_COUNTDOWN,
        )
