"""
base settings.
had to explicitly specify settings search dir for granular settings, or
PyCharm debugger would not work
"""
import os.path
from builtins import str

import granular_settings


def get_environment_type():
    """Возвращает тип окружения (production, testing, development, localhost)."""
    ENVTYPE = os.environ.get('ENVTYPE')

    return ENVTYPE.split() if ENVTYPE else ['localhost']


def get_setting(name, default=None, cast=None, many=False, delimiter=','):
    """Берёт настройку из переменной окружения, приводя к нужному типу."""
    if many and default and not (isinstance(default, list) or isinstance(default, tuple)):
        raise RuntimeError('default must be iterable')
    if many and not default:
        default = []
    many = isinstance(default, list) or isinstance(default, tuple)

    value = os.getenv(name)

    if value is None:
        return default

    if default is not None and cast is None:
        cast = guess_cast_using_default(default, many)
    elif cast is None:
        cast = str

    if cast is bool:
        cast = cast_bool

    if many:
        return [cast(str(v).strip()) for v in value.split(delimiter)]

    return cast(value)


def cast_bool(value):
    return value.lower() in ('yes', 'true', '1')


def guess_cast_using_default(default, many):
    if many:
        try:
            return type(default[0])
        except IndexError:
            return str
    else:
        return type(default)


ENVTYPE = get_environment_type()

# добавляем реальный путь к проекту, т.к. granular_settings его определяет по-другому
path = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'settings')
granular_settings.set(globals(), path=path, envtype=ENVTYPE)
