from django.contrib import admin


class CodeUsedFilter(admin.SimpleListFilter):
    """
    Фильтрация кодов по использованности
    """
    title = u'Код использован'
    parameter_name = 'code_used'
    LOOKUPS = (
        ('1', u'Да'),
        ('2', u'Нет'),
    )

    def queryset(self, request, queryset):
        if self.value() is None:
            return queryset
        elif self.value() == self.LOOKUPS[0][0]:
            return queryset.filter(activated_by__isnull=False)
        elif self.value() == self.LOOKUPS[1][0]:
            return queryset.filter(activated_by__isnull=True)

    def lookups(self, request, model_admin):
        return self.LOOKUPS
