from django import forms
from django.contrib.auth import get_user_model

from kelvin.staff_notifications.models import NewTeacherAction

User = get_user_model()


class CodeBatchCreateForm(forms.Form):
    """
    Форма для создания набора кодов
    """
    count = forms.IntegerField(
        label='Количество кодов',
        initial=10,
        min_value=1,
        max_value=100,
        required=True,
    )
    actions = forms.ModelMultipleChoiceField(
        label='Действия',
        queryset=NewTeacherAction.objects.all(),
        required=False,
    )
