from kelvin.accounts.models import User
from kelvin.celery import app
from kelvin.courses.models import Course
from kelvin.staff_notifications.models import NotificationEmail


@app.task(bind=True, max_retries=3)
def notify_about_teacher(self, user_id):
    """
    Рассылает уведомления, что учитель получил доступ к тем,
    или иным материалам.
    """
    try:
        owner = User.objects.get(id=user_id)
        courses = Course.objects.filter(owner__id=user_id)
        NotificationEmail.objects.notify_about_teacher(owner, courses)
    except Exception as exc:
        self.retry(exc=exc)
