import re

from django.core.exceptions import ValidationError

CODE_REGEX = re.compile(r'^[a-z0-9]{10}$')


def validate_code(code):
    """
    Проверяем, что код содержить только цифры и строчные латинские буквы,
    а также имеет длину 10
    """
    if not (CODE_REGEX.match(code)):
        raise ValidationError(u'Incorrect code: {0}'.format(code))
