import json

from kelvin.stress_fire.helpers.generate_request import build_post_request


class Ammo(object):
    URL = None
    TAG = ''
    METHOD = None
    CSRF_TOKEN = 'CSRF'
    DEFAULT_HEADERS = [
        'Host: api.stress.corp-education.yandex-team.ru',
        'Accept: */*',
        'Accept-Language: ru-RU,ru;q=0.8,en-US;q=0.6,en;q=0.4',
        'Accept-Encoding: gzip,deflate,br',
        'Content-Type: application/json',
        'Connection: keep-alive',
    ]

    def __init__(self):
        self.user_structure = {
            'user': None,
            'session': None,
            'uid': None,
        }

    def get_body(self):
        return {}

    def get_url_params(self):
        return {}

    def get_query_params(self):
        if hasattr(self, 'query_params'):
            return self.query_params

        return None

    def get_headers(self):
        return self.DEFAULT_HEADERS

    def build_request(self):

        body = json.dumps(self.get_body())
        return build_post_request(
            path=self.URL.format(**self.get_url_params()),
            method=self.METHOD,
            tag=self.TAG,
            headers=self.get_headers(),
            body=body,
            query_params=self.get_query_params(),
        )
