import random
from functools import partial

from kelvin.stress_fire.ammo.clesson_web import GeneratorClessonWeb
from kelvin.stress_fire.ammo.course_web import GeneratorCourseWeb
from kelvin.stress_fire.ammo.library import GeneratorLibrary
from kelvin.stress_fire.ammo.me import GeneratorMe
from kelvin.stress_fire.ammo.patch_clesson import GeneratorPatchClessonResult
from kelvin.stress_fire.ammo.post_clesson import GeneratorPostClessonResult
from kelvin.stress_fire.ammo.put_scorm import GeneratorPutScorm
from kelvin.stress_fire.ammo.sirius_courses import GeneratorSiriusCourses
from kelvin.stress_fire.ammo.stat import GeneratorCourseStat
from kelvin.stress_fire.ammo.strict import GeneratorCourseStrictAmmo

DEFAULT_AMMO_GENERATORS = {
    'GeneratorClessonWeb': GeneratorClessonWeb,
    'GeneratorClessonWebExpandProblems': partial(GeneratorClessonWeb, expand_problems=True),
    'GeneratorClessonWebExpandProblemsExpandMeta': partial(GeneratorClessonWeb, expand_problems=True, expand_meta=True),
    'GeneratorCourseWeb': GeneratorCourseWeb,
    'GeneratorCourseWebWithStudents': partial(GeneratorCourseWeb, with_students=True),
    'GeneratorLibrary': GeneratorLibrary,
    'GeneratorMe': GeneratorMe,
    'GeneratorPatchClessonResult': GeneratorPatchClessonResult,
    'GeneratorPutScorm': GeneratorPutScorm,
    'GeneratorSiriusCourses': GeneratorSiriusCourses,
    'GeneratorCourseStat': GeneratorCourseStat,
    'GeneratorCourseStrictAmmo': GeneratorCourseStrictAmmo,
}


DEFAULT_AMMO_PROFILES = {
    "GeneratorClessonWeb": 1,
    'GeneratorClessonWebExpandProblems': 176624,
    'GeneratorClessonWebExpandProblemsExpandMeta': 14443,
    "GeneratorCourseWeb": 84904,
    "GeneratorCourseWebWithStudents": 83428 + 10204,
    "GeneratorLibrary": 40713,
    "GeneratorMe": 157611 + 9435,
    "GeneratorPatchClessonResult": 915593,
    "GeneratorPutScorm": 953408,
    "GeneratorSiriusCourses": 536,
    "GeneratorCourseStat": 83087 + 9312,
    "GeneratorCourseStrictAmmo": 283623,
}


class GeneratorMixedAmmos(object):
    def __init__(self, count_ammos, ammo_profile=None, ammo_generators=None):
        self.count_ammos = count_ammos
        self.ammo_profile = ammo_profile or DEFAULT_AMMO_PROFILES
        self.ammo_generators = ammo_generators or DEFAULT_AMMO_GENERATORS

    def generate_ammos(self):
        generators = {
            ammo_generator_name:
                self.ammo_generators[ammo_generator_name](count_ammos=self.count_ammos).generate_ammos()
            for ammo_generator_name in self.ammo_generators
        }

        ammos_seqs = random.choices(
            population=list(self.ammo_profile.keys()),
            weights=[val for key, val in self.ammo_profile.items()],
            k=self.count_ammos,
        )

        for ammo_seq in ammos_seqs:
            yield next(generators[ammo_seq])
