from future.builtins import range

from kelvin.courses.models import CourseStudent
from kelvin.stress_fire import settings
from kelvin.stress_fire.ammo.base import Ammo
from kelvin.stress_fire.fixtures.build_course import build_course
from kelvin.stress_fire.fixtures.users import create_students


class PostClessonResultAmmo(Ammo):

    URL = '/api/v2/post-clesson-results/{result_id}/'
    METHOD = 'POST'
    TAG = 'PostClessonResult'

    def __init__(self, course_structure, user_structure):
        super(PostClessonResultAmmo, self).__init__()
        self.course_structure = course_structure
        self.user_structure = user_structure

    def get_body(self):
        return {
            'clessonId': self.course_structure['clesson_private'].id,
        }


class GeneratorPostClessonResult(object):
    """
    Ручка /api/post-clesson-results/
    Ученики по очереди шлют запросы в курсы.
    Все студенты являются учениками всех курсов.
    Например: учеников 3, курсов 2.
    Патроны (ученик - курс):
    0 - 0
    1 - 1
    2 - 0
    3 - 1
    ...
    """
    DEFAULT_COUNT_OF_COURSES = 1
    PARAMS = {
        'count_users': None,
        'count_courses': None,
        'course_mode': None,
        'count_ammos': None,
    }

    def __init__(
        self,
        count_users=settings.DEFAULT_COUNT_OF_USERS,
        count_courses=DEFAULT_COUNT_OF_COURSES,
        course_mode=settings.DEFAULT_COURSE_MODE,
        count_ammos=settings.DEFAULT_COUNT_OF_AMMOS,
    ):
        self.count_ammos = count_ammos
        self.students_data = create_students(count_users)
        self.users = self.students_data['users']
        self.courses = [
            build_course(course_mode=course_mode) for _ in range(count_courses)
        ]
        CourseStudent.objects.bulk_create([
            CourseStudent(
                course=course['course_private'],
                student=student,
            ) for student in self.users for course in self.courses
        ])

    def generate_ammos(self):
        count_users = len(self.users)
        count_courses = len(self.courses)
        for ammo_number in range(self.count_ammos):
            yield PostClessonResultAmmo(
                self.courses[ammo_number % count_courses],
                self.users[ammo_number % count_users],
            ).build_request()
