import random
import uuid

from django.utils import timezone

from kelvin.accounts.models import User
from kelvin.courses.models import Course, CourseLessonLink
from kelvin.lessons.models import Lesson, LessonProblemLink
from kelvin.problems.models import Problem
from kelvin.subjects.models import Subject


def build_base_course(course_mode=1):
    teacher, _ = User.objects.get_or_create(
        username=u'teacher',
        email='teacher@yandex.ru',
        is_teacher=True,
    )
    subject, _ = Subject.objects.get_or_create(
        slug='math',
        defaults={
            'name': 'Высшая математика',
        }
    )
    return Course.objects.create(
        owner=teacher,
        subject=subject,
        code=uuid.uuid4().hex[:Course.CODE_LENGTH],
        allow_anonymous=False,
        mode=course_mode,
    )


# FIXME EDUCATION-12771: incorrect course generation
def build_course(teacher=None, course_mode=1, count_problems=8, count_lessons=20, project=None):
    """Builds course for patch_clesson ammo."""

    subject, _ = Subject.objects.get_or_create(
        slug='math',
        defaults={
            'name': 'Высшая математика',
        }
    )

    markup = {
        'layout': [
            {
                'content': {
                    'text': u'Вычислите значение **выражения** '
                            u'$-0{,}6:  5  : ( -0{,}3 )$.',
                    'options': {'style': 'normal'},
                },
                'kind': 'text',
            },
            {
                'content': {
                    'type': 'field',
                    'id': 1,
                    'options': {'type_content': 'number'},
                },
                'kind': 'marker',
            },
        ],
        'checks': {},
        'answers': {'1': '4'},
        'solution': '$-0{,}6:  5  : ( -0{,}3 ) = \\dfrac{ -0{,}12 }'
                    '{ -0{,}3 } = 0{,}4$.',
        'cm_comment': u'секретный комментарий',
    }

    if teacher is None:
        mail_log = ''.join(random.choice('abcde') for _ in range(10))
        teacher = User.objects.create(
            username=uuid.uuid4().hex,
            email=mail_log + '@yandex.ru',
            is_teacher=True,
            yauid=random.randint(10 ** 6, 10 ** 7 - 1),
        )

    problems = Problem.objects.bulk_create([
        Problem(
            name=u'Task {}'.format(i),
            owner=teacher,
            subject=subject,
            markup=markup,
        ) for i in range(count_problems)
    ])

    lesson_privates = Lesson.objects.bulk_create([
        Lesson(owner=teacher) for i in range(count_lessons)
    ])

    lesson_private = Lesson.objects.create(owner=teacher)

    course_private = Course.objects.create(
        owner=teacher,
        project=project,
        subject=subject,
        code=uuid.uuid4().hex[:Course.CODE_LENGTH],
        allow_anonymous=False,
        mode=course_mode,
        free=True,
    )

    lesson_private_problem_links_to_create = []
    for lesson_private in lesson_privates:
        for i, problem in enumerate(problems):
            params = {
                'lesson': lesson_private,
                'problem': problem,
                'order': i,
                'options': {'max_points': 1, 'max_attempts': 1_000_000}
            }
            lesson_private_problem_links_to_create.append(
                LessonProblemLink(**params)
            )

        clesson_private = CourseLessonLink.objects.create(
            course=course_private,
            lesson=lesson_private,
            date_assignment=timezone.now(),
        )

    lesson_private_problem_links = LessonProblemLink.objects.bulk_create(lesson_private_problem_links_to_create)

    return {
        'teacher': teacher,
        'subject': subject,
        'problems': problems,
        'lesson_private': lesson_private,
        'course_private': course_private,
        'lesson_private_problem_links': lesson_private_problem_links,
        'clesson_private': clesson_private,
    }
