# coding=utf-8
from yql.api.v1.client import YqlClient

QUERY_PROFILE = """
use hahn;
SELECT url, ratio, request_count, avg_time, perc_99, perc_95 
from [//home/education/stress/requests_profile];
"""


def get_urls_profile():
    """
    Get urls profile from YT /stress/requests_profile table.
    Show data for production environment
    """
    client = YqlClient(db='hahn')
    request = client.query(QUERY_PROFILE)
    request.run()

    lines = []

    for table in request.get_results():
        for row in table.rows:
            lines.append({
                'url': row[0],
                'ratio': int(round(row[1] * 100)),
            })

    return lines
