import json
import logging
import random
import uuid

import blackbox

from django.core.signing import get_cookie_signer

# from kelvin.accounts.auth import Auth
from kelvin.accounts.models import User
# from kelvin.accounts.models.login import Login
# from kelvin.contacts.models import School
from kelvin.stress_fire.settings import BLACKBOX_URL

# from kelvin.teams.models import TeacherTeam, Team

bb = blackbox.XmlBlackbox(url=BLACKBOX_URL)

logger = logging.getLogger(__name__)


def create_students(count_users, page_size=50):
    """
    Creates new random school, team and teacher
    Creates random count_users students with login and assign them to teacher
    """
    users = []

    for _ in range(0, count_users, page_size):
        mail_log = ''.join(random.choice('abcde') for _ in range(10))

        teacher = User.objects.create(
            username=uuid.uuid4().hex,
            email=mail_log + '@yandex.ru',
            is_teacher=True,
            yauid=random.randint(10 ** 6, 10 ** 7 - 1),
        )

        # school = School.objects.create(
        #     name=uuid.uuid4().hex,
        #     full_name=uuid.uuid4().hex,
        #     locality_geoid=1,
        # )

        teacher.teacher_profile.region = u'Moscow'
        # teacher.teacher_profile.school = school
        teacher.teacher_profile.save()

        # team = Team.objects.create(
        #     level=3,
        #     name=uuid.uuid4().hex,
        #     supervisor=teacher.teacher_profile,
        # )

        # TeacherTeam.create_valid(team.id, teacher.id)

        students = [
            User(
                first_name=uuid.uuid4().hex,
                last_name=uuid.uuid4().hex,
                username=uuid.uuid4().hex,
                yauid=random.randint(10 ** 6, 10 ** 7 - 1),
                parent_code=User.generate_parent_code(),
            )
            for _ in range(page_size)
        ]

        users = User.objects.bulk_create(students)

        # team.bulk_create_students(students_data)

        # Login.generate_logins(
        #     school_id=teacher.teacher_profile.school.id,
        #     count=page_size + 10,
        # )

    return {
        "users": users,
        "teacher": teacher,
    }


def create_users_with_yauid(lines):
    """
    Removes dead users and ensures that alive are existing in Kelvin.
    Returns list or dicts (username, uid, session, user).
    """

    results = {}

    for line in lines:
        line_json = json.loads(line)
        uid = line_json.get('default_uid')
        session = line_json.get('new-sslsession', {}).get('value')
        try:
            session_data = bb.sessionid(
                session,
                '127.0.0.1',
                'yandex.ru',
                dbfields=(
                    blackbox.FIELD_LOGIN,
                    ('userinfo.lastname.uid', 'last_name'),
                    ('userinfo.firstname.uid', 'first_name'),
                )
            )
            if session_data['status'] == 'INVALID':
                continue

            username = session_data['fields'].get('login')
            if not username:
                continue

            logger.info('User get from bb: {}'.format(username))

            results[username] = {
                'username': username,
                'uid': uid,
                'session': session,
            }
        except Exception as e:
            print(e)

    users = list(results.values())
    for user_data in users:
        user, created = User.objects.get_or_create(
            username=user_data['username'],
            yauid=user_data['uid'],
        )
        user_data['user'] = user
    return users
