# coding=utf-8
from django.core.files.base import ContentFile
from django.core.files.storage import default_storage

from kelvin.celery import app
from kelvin.stress_fire.ammo import AMMO_GENERATORS
from kelvin.stress_fire.settings import get_ammo_path
from plato.common.decorators.task_logger import logged_task
from plato.common.redis import redis

AMMO_PARAMS_MAP = {
    'count_users': int,
    'count_courses': int,
    'course_mode': int,
    'count_ammos': int,
    'count_problems': int,
    'count_lessons': int,
    'is_evaluable': bool,
    'expand_lessons': bool,
    'geoid': int,
    'school_name': str,
    'parent_code': str,
    'count_parents': int,
    'count_students': int,
    'count_teams': int,
}


def map_ammo_get_params(**params):
    params = dict([(str(k), v) for k, v in params.items()])
    return dict(
        (
            key,
            AMMO_PARAMS_MAP[str(key)](value)
            if AMMO_PARAMS_MAP[str(key)](value) else value
        )
        for key, value in params.iteritems()
    )


# FIXME EDUCATION-12771: not work in localhost mode
@logged_task
@app.task(acks_late=True)
def generate_ammo(name, *args, **kwargs):
    """
    Generate ammo and save to file.
    """

    try:
        Generator = AMMO_GENERATORS[name]
        if default_storage.exists(get_ammo_path(name)):
            default_storage.delete(get_ammo_path(name))

        redis.client.set(name, 'Generating ammo file')
        rows = [row for row in Generator(
            *args, **map_ammo_get_params(**kwargs)
        ).generate_ammos()]

        redis.client.set(name, 'Saving ammo file')
        content = ContentFile('\n'.join(rows))
        default_storage.save(get_ammo_path(name), content)

        redis.client.set(name, 'Done')
    except Exception as e:
        redis.client.set(name, 'Exception: {}'.format(e.message))
        raise e
