from urllib.parse import urlencode

REQUEST_TEMPLATE = '{method} {path} HTTP/1.0'
CONTENT_LENGTH = 'Content-Length: {body_length}'


def build_post_request(path, method='POST', tag='', headers=None, body=None, query_params=None):
    """Builds request data for ammo."""

    if query_params:
        path += "?" + urlencode(query_params)
    request = REQUEST_TEMPLATE.format(method=method, path=path)
    if headers is None:
        headers = []
    if body is not None:
        headers += [CONTENT_LENGTH.format(body_length=len(body))]
        result = ['', body]
    else:
        result = []
    result = '\n'.join([request] + headers + result)
    return '\n'.join([f'{str(len(result))} {tag}', result, '', ''])
