# coding=utf-8
from django.core.files.storage import default_storage
from django.http import HttpResponse, HttpResponseRedirect
from django.template.loader import get_template

from kelvin.stress_fire.ammo import AMMO_GENERATORS
from kelvin.stress_fire.fixtures.urls_profile import get_urls_profile
from kelvin.stress_fire.helpers.generate_ammo import generate_ammo
from kelvin.stress_fire.settings import SESSIONS_PATH, get_ammo_path
from plato.common.redis import redis

ALERTS = {
    'ammo_generation_started': 'Генерация патронов запущена.',
    'file_deleted': 'Файл удален.',
    'file_not_found': 'Файл не найден.',
}


def urls_profile(request):
    template = get_template('stress_fire/urls_profile.html')
    context = {'urls': get_urls_profile()}
    return HttpResponse(template.render(context))


def get_ammo_list(request):
    template = get_template('stress_fire/ammo_list.html')
    sessions_is_exist = default_storage.exists(SESSIONS_PATH)
    ammo_list = []
    alert = request.GET.get('alert')
    for ammo_name, generator in AMMO_GENERATORS.iteritems():
        ammo_list.append({
            'name': ammo_name,
            'title': generator.__doc__,
            'exists': default_storage.exists(get_ammo_path(ammo_name)),
            'status': redis.client.get(ammo_name) or 'Empty',
            'params': generator.PARAMS.keys(),
        })
    context = {
        'ammo_list': ammo_list,
        'alert_text': ALERTS.get(alert),
        'sessions_is_exist': sessions_is_exist,
    }

    return HttpResponse(template.render(context))


def make_ammo_by_name(request, name):
    redis.client.set(name, 'Compiling')
    generate_ammo.delay(name, **request.GET.dict())
    return HttpResponseRedirect('/stress/?alert=ammo_generation_started')


def download_ammo_by_name(request, name):
    file_path = get_ammo_path(name)
    if not default_storage.exists(file_path):
        return HttpResponse('Патрон не найден')

    response = HttpResponse(
        default_storage.open(file_path).readlines(),
        content_type='text/txt',
    )
    response['Content-Disposition'] = (
        'attachment; filename={}'.format('{}.txt'.format(name))
    )
    return response


def download_sessions(request):
    if not default_storage.exists(SESSIONS_PATH):
        return HttpResponseRedirect('/stress/?alert=file_not_found')

    response = HttpResponse(
        default_storage.open(SESSIONS_PATH).readlines(),
        content_type='text/txt',
    )
    response['Content-Disposition'] = (
        'attachment; filename={}'.format('{}.txt'.format(SESSIONS_PATH))
    )
    return response


def delete_sessions(request):
    if not default_storage.exists(SESSIONS_PATH):
        return HttpResponseRedirect('/stress/?alert=file_not_found')

    default_storage.delete(SESSIONS_PATH)
    return HttpResponseRedirect('/stress/?alert=file_deleted')
