from mptt.admin import MPTTModelAdmin

from django.contrib import admin

from kelvin.subjects.models import Subject, Theme


class SubjectAdmin(admin.ModelAdmin):
    """
    Админка модели учебного предмета
    """
    list_display = (
        'slug',
        'name',
        'public',
    )
    list_display_links = None
    list_editable = (
        'slug',
        'name',
        'public',
    )


class ThemeAdmin(MPTTModelAdmin):
    """
    Админка модели учебной темы
    """
    list_display = (
        'name', 'code', 'subject',
    )
    mptt_indent_field = "name"
    list_filter = ('subject',)


admin.site.register(Subject, SubjectAdmin)
admin.site.register(Theme, ThemeAdmin)
