from builtins import object

import django_filters

from kelvin.common.filters import ListFilter
from kelvin.subjects.models import Subject, Theme


class ThemeFilter(django_filters.FilterSet):
    """
    Фильтрация для `ThemeListView` по id, имени темы и предмету. Можно
    запрашивать несколько id
    """
    id = ListFilter(field_name='id')
    name = django_filters.CharFilter(field_name='name', lookup_expr='istartswith')
    subject = django_filters.NumberFilter(field_name='subject', lookup_expr='exact')

    class Meta(object):
        model = Theme
        fields = ['id', 'name', 'subject']
