from builtins import object, str

from mptt.models import MPTTModel, TreeForeignKey

from django.db import models
from django.utils.encoding import python_2_unicode_compatible
from django.utils.translation import ugettext_lazy as _


@python_2_unicode_compatible
class Subject(models.Model):
    """
    Учебный предмет
    """
    slug = models.CharField(
        verbose_name=_('Слаг-идентификатор учебного предмета'),
        max_length=255,
        unique=True,
    )
    name = models.CharField(
        verbose_name=_('Название учебного предмета'),
        max_length=255,
    )
    public = models.BooleanField(
        verbose_name=_('Доступный предмет'),
        default=True,
    )

    class Meta(object):
        verbose_name = _('Предмет')
        verbose_name_plural = _('Предметы')

    def __str__(self):
        return str(self.name)


@python_2_unicode_compatible
class Theme(MPTTModel):
    """
    Учебная тема
    """
    name = models.CharField(
        verbose_name=_('Название темы'),
        max_length=255,
    )
    code = models.CharField(verbose_name=_('Код темы'), max_length=255)
    parent = TreeForeignKey('self', null=True, blank=True,
                            related_name='children', db_index=True)
    subject = models.ForeignKey(Subject)

    class Meta(object):
        verbose_name = _('Тема')
        verbose_name_plural = _('Темы')

    class MPTTMeta(object):
        order_insertion_by = ['code']

    def __str__(self):
        return str(self.name)


def get_default_subject():
    """
    Дефолтный предмет
    """
    return Subject.objects.get_or_create(
        slug='mathematics', name='Математика')[0]
