from builtins import object

from rest_framework import serializers

from kelvin.subjects.models import Subject, Theme


class SubjectSerializer(serializers.ModelSerializer):
    """
    Сериализатор для модели Предметы
    """
    class Meta(object):
        model = Subject
        fields = ('id', 'slug', 'name')
        read_only_fields = ('id',)


class ThemeSerializer(serializers.ModelSerializer):
    """
    Сериалайзер для тем
    """
    class Meta(object):
        model = Theme
        fields = (
            'id',
            'name',
            'code',
            'subject',
            'level',
            'parent',
        )
        read_only_fields = ['level']
        extra_kwargs = {
            'parent': {'write_only': True},
        }


class ThemeShortSerializer(serializers.ModelSerializer):
    """
    Сериализатор для краткого представления тем
    """
    class Meta(object):
        model = Theme
        fields = (
            'id',
            'name',
        )
