from rest_condition import Or

from rest_framework import mixins, viewsets

from kelvin.accounts.permissions import IsContentManager, IsStaff, IsTeacher
from kelvin.subjects.filters import ThemeFilter
from kelvin.subjects.models import Subject, Theme
from kelvin.subjects.serializers import SubjectSerializer, ThemeSerializer


class ThemeListView(mixins.ListModelMixin,
                    viewsets.GenericViewSet):
    queryset = Theme.objects.all()
    serializer_class = ThemeSerializer
    filter_class = ThemeFilter
    permission_classes = [
        Or(IsTeacher,
           IsContentManager,
           IsStaff),
    ]


class SubjectListView(mixins.ListModelMixin, viewsets.GenericViewSet):
    """Плоский список предметов"""
    pagination_class = None
    permission_classes = [
        Or(IsTeacher,
           IsContentManager,
           IsStaff),
    ]
    queryset = Subject.objects.filter(public=True)
    serializer_class = SubjectSerializer
