"""
    Module to abstract getting business features options
    from place where they are stored.
    It could be env variables , django settings or
    standalone application for options managing
"""
import os
from builtins import str

FEATURES = {
    'E7N_ENABLE_NEW_RESOURCE_URLS': 'Return short fail '
                                    'url instead of original S3 url',
    'E7N_ENABLE_NEW_COURSE_PERMISSIONS': 'Use CoursePermission entity to detect course permissions for user',
    'E7N_ENABLE_COURSES_AVAILABLE_EXTERNAL_DEFAULT': 'Make all courses available by default',
    'E7N_USE_CUSTOM_STAFF_GROUPS_CACHE': 'Use non django-specific staff group cache',
    'YAUTH_CREATE_USER_ON_ACCESS': 'Create user on access automatically'
}


def get_feature_bool_option(feature_option_name='', default_value=False):
    if not FEATURES.get(feature_option_name, False):
        raise NotImplementedError(
            "No such feature implemented {0}".format(feature_option_name)
        )
    opt_value = os.environ.get(feature_option_name, default_value)
    return True if str(opt_value).lower() == 'true' or opt_value == "1" else False
