from django.contrib import admin

from .models import Tag, TaggedObject


@admin.register(Tag)
class TagAdmin(admin.ModelAdmin):
    list_filter = ('type', )


@admin.register(TaggedObject)
class TaggedObjectAdmin(admin.ModelAdmin):
    list_filter = ('tag__type', )
    raw_id_fields = ('content_type', 'tag', )
