from collections import Counter

from django.core.management.base import BaseCommand

from kelvin.tags.models import Tag


class Command(BaseCommand):
    help = "Cast 'id' and 'level' values to int"

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self.counter = Counter()

    def add_arguments(self, parser):
        parser.add_argument('--dry-run', action='store_true', help='Run without commit to db')

    def handle(self, *args, **options):
        if options['dry_run']:
            self.stdout.write('Dry run (without commit to db)')

        failed_to_update_tag_ids = []
        tags = Tag.objects.all()
        for tag in tags:
            self.counter['total'] += 1
            updated = False
            try:
                if not isinstance(tag.data.get('id', 0), int):
                    tag.data['id'] = int(tag.data['id'])
                    updated = True
                if not isinstance(tag.data.get('level', 0), int):
                    tag.data['level'] = int(tag.data['level'])
                    updated = True
                if updated:
                    if not options['dry_run']:
                        tag.save()
                    self.counter['updated'] += 1
            except Exception as e:
                failed_to_update_tag_ids.append(tag.id)
                self.stderr.write(str(e))

        self.stdout.write(f"Total items: {self.counter['total']}\n"
                          f"Updated: {self.counter['updated']}\n"
                          f"Failed to update ({len(failed_to_update_tag_ids)}): {failed_to_update_tag_ids}")
