from builtins import object

from rest_framework import serializers

from kelvin.tags.models import Tag, TagTypeAdapter


class TagSerializer(serializers.ModelSerializer):

    internal_type = serializers.SerializerMethodField()
    operations = serializers.SerializerMethodField()

    def get_internal_type(self, obj):
        return obj.internal_type

    def get_operations(self, obj):
        return TagTypeAdapter.get_tag_type_for_db_type(obj.type).get_operations()

    class Meta(object):
        model = Tag
        fields = [
            'id',
            'internal_type',
            'semantic_type',
            'semantic_type_l10n',
            'value',
            'operations',
        ]


class TagTypeSerializer(serializers.Serializer):
    is_dynamic = serializers.SerializerMethodField()
    semantic_type = serializers.SerializerMethodField()
    language_type = serializers.SerializerMethodField()
    operations = serializers.SerializerMethodField()

    def get_is_dynamic(self, tag_type):
        return tag_type.is_dynamic()

    def get_semantic_type(self, tag_type):
        return tag_type.get_semantic_type_name()

    def get_language_type(self, tag_type):
        return tag_type.get_language_type_name()

    def get_operations(self, tag_type):
        return tag_type.get_operations()

    class Meta(object):
        fields = (
            'is_dynamic',
            'semantic_type',
            'language_type',
            'operations',
        )
