from builtins import str

from django.db.models.signals import post_save

from kelvin.projects.models import Project

from .models import Tag, TagTypeProject


def create_project_tag(sender, instance, **kwargs):
    """
    Создает тэг проекта.
    """
    Tag.objects.get_or_create(
        project=instance,
        type=TagTypeProject.get_db_type(),
        value=str(instance.id),
    )


post_save.connect(create_project_tag, Project)
