from builtins import object

from rest_framework import serializers

from kelvin.accounts.serializers import BaseUserSerializer, UserSerializer
from kelvin.accounts.utils import get_user_projects
from kelvin.courses.models import Course, CourseFeedback
from kelvin.courses.serializers import CourseFeedbackSerializer
from kelvin.lessons.serializers import LessonSerializer
from kelvin.news.models import News
from kelvin.news.serializers import NewsSerializer
from kelvin.results.models import CourseLessonSummary, LessonSummary
from kelvin.results.serializers import CourseLessonSummarySerializer, LessonSummarySerializer
from kelvin.subjects.serializers import SubjectSerializer


class TakeoutCourseSerializer(serializers.ModelSerializer):
    subject = SubjectSerializer()
    lessons = LessonSerializer(many=True)

    class Meta(object):
        model = Course
        fields = [
            'id',
            'info',
            'name',
            'description',
            'date_created',
            'date_updated',
            'lessons',
            'subject',
        ]


class TakeoutUserSerializer(UserSerializer):
    courses = serializers.SerializerMethodField()
    projects = serializers.SerializerMethodField()
    feedbacks = serializers.SerializerMethodField()
    news = serializers.SerializerMethodField()
    # tags = serializers.SerializerMethodField()
    lesson_summary = serializers.SerializerMethodField()
    course_lesson_summary = serializers.SerializerMethodField()

    def get_courses(self, obj):
        return TakeoutCourseSerializer(
            Course.objects.filter(owner=obj),
            many=True,
        ).data

    def get_projects(self, obj):
        return [
            {
                "id": p.id,
                "title": p.title
            } for p in get_user_projects(obj)
        ]

    def get_feedbacks(self, obj):

        return CourseFeedbackSerializer(
            CourseFeedback.objects.filter(user=obj),
            many=True
        ).data

    def get_news(self, obj):
        return NewsSerializer(
            News.objects.filter(owner=obj),
            many=True
        ).data

    # def get_tags(self, obj):
    #     return [{
    #         "value": tag.value,
    #         "type": TagTypeAdapter.get_tag_type_for_db_type(tag.type).get_semantic_type_name_l10n(),
    #     } for tag in Tag.objects.filter(
    #         tagged_objects__object_id=obj.id,
    #         tagged_objects__content_type=ContentType.objects.get_for_model(User),
    #     )]

    def get_lesson_summary(self, obj):
        return LessonSummarySerializer(
            LessonSummary.objects.filter(student=obj),
            many=True,
        ).data

    def get_course_lesson_summary(self, obj):
        return CourseLessonSummarySerializer(
            CourseLessonSummary.objects.filter(student=obj),
            many=True,
        ).data

    class Meta(BaseUserSerializer.Meta):
        fields = UserSerializer.Meta.fields + (
            "courses",
            "projects",
            "feedbacks",
            "news",
            # "tags",
            "lesson_summary",
            "course_lesson_summary",
        )
