from builtins import object

from django.db import models
from django.utils.translation import ugettext_lazy as _


class TVMService(models.Model):
    service_id = models.IntegerField(
        verbose_name=_('ID сервиса'),
        primary_key=True,
    )
    slug = models.SlugField(
        max_length=255,
        verbose_name=_('Слаг сервиса'),
        unique=True,
    )
    name = models.CharField(
        max_length=255,
        verbose_name=_('Имя сервиса'),
    )

    def __str__(self):
        return '{} ({})'.format(self.slug, self.service_id)

    class Meta(object):
        verbose_name = _('TVM-сервис')
        verbose_name_plural = _('TVM-сервисы')
