import os

from django_replicated.decorators import use_state
from rest_framework_nested import routers

from django.conf import settings
from django.conf.urls import include, url
# для загруженных файлов в девелопменте
from django.conf.urls.static import static  # noqa
from django.contrib import admin

from rest_framework.routers import DefaultRouter

from kelvin.accounts.views import (
    SiriusUserViewSet, StudyGroupViewSet, UserProfileView, UserViewSet, auto_add_to_project, create_profile,
    create_user_for_project,
)
from kelvin.achievery import urls as achievery_urls
from kelvin.certificates.views import RenderedCertificateViewSet
# раздаем статику гуникорном, чтобы не настраивать поверх nginx и потому что в
# апи без браузера она не нужна, а админкой пользуется конечное малое число
# людей
from kelvin.common.urls import staticfiles_urlpatterns  # noqa
from kelvin.common.views import auth_ping, ping, simple_upload
from kelvin.courses.views import (
    AssignmentRuleEdgesViewSet, AssignmentRuleEdgeViewSet, AssignmentRuleTriggersViewSet, AssignmentRuleViewSet,
    CLessonViewSet, CourseEditViewSet, CourseViewSet, SiriusCLesson, SiriusCourses, SiriusCourses3, SourceCourseViewSet,
)
from kelvin.courses.views.course.course import ReportCourseViewSet
from kelvin.courses.views.course.course3 import CourseViewSet3
from kelvin.courses.views.course_invite import CourseInviteViewSet
from kelvin.courses.views.course_students import CourseStudentsViewSet
from kelvin.courses.views.course_students_results import CourseStudentsResultsViewSet
from kelvin.idm import urls as idm_urls
from kelvin.lesson_assignments.views import LessonAssignmentViewSet
from kelvin.news.views import NewsViewSet
from kelvin.player.views import PlayerDataViewSet
from kelvin.problems.views import ContentTypeViewSet, MarkerViewSet, ProblemViewSet, TextResourceViewSet
from kelvin.projects.views import ProjectSubjectViewSet, ProjectViewSet, ProjectViewSetAdmin
from kelvin.reports.views import (
    CourseReportRequestDetailView, CourseReportRequestView, CourseReportResultDataDetailView, QueryDetailAPIView,
    QueryListAPIView, ReportFormatAPIView,
)
from kelvin.resources.views import ResourceViewSet
from kelvin.results.views import (
    CourseLessonCommentViewSet, CourseLessonResultViewSet, ResetClessonResults, ResetClessonResultsV3,
)
from kelvin.reviews.views import ReviewTaskViewSet
from kelvin.sapi.views import SiriusStudentCourseStat
from kelvin.scorm.views import ScormISpringSuiteViewSet, ScormResourceUserDataViewSet, ScormViewSet
from kelvin.staff_notifications.views import ActivationCodeViewSet
from kelvin.subjects.views import SubjectListView, ThemeListView
from kelvin.tags.views import TagTypeViewSet, TagViewSet
from kelvin.takeout.views import TakeoutView
from kelvin.user_files.views import UserFilesPermissionViewSet

# fix default django_replicated decorators
use_master = use_state(forced_state='master')

# to include all urls write them there
router = DefaultRouter()
# router.register(r'blocks', BlockViewSet, 'block')
# router.register(r'exams', ExamViewSet, 'exam')
# router.register(r'edu_exams', ExamEduImportViewSet, 'edu_exam')
router.register(r'certificates', RenderedCertificateViewSet, 'certificates')
router.register(r'clessons', CLessonViewSet, 'course_lesson')
router.register(r'clesson_results',
                CourseLessonResultViewSet,
                'course_lesson_result')
router.register(r'clesson_results',
                CourseLessonCommentViewSet,
                'course_lesson_result_comment')
router.register(r'scorm', ScormViewSet, 'scorm')
router.register(r'scorm-ispring-suite', ScormISpringSuiteViewSet, 'scorm_ispring_suite')

router.register(r'review-tasks', ReviewTaskViewSet, 'review_tasks')

# router.register(r'clesson_summary',
#                 CourseLessonSummaryViewSet,
#                 'course_lesson_summary')
router.register(r'courses', CourseViewSet, 'course')
router.register(r'courses-edit', CourseEditViewSet, 'course-edit')
router.register(r'report-courses', ReportCourseViewSet, 'report-course')
router.register(r'source_courses', SourceCourseViewSet, 'source_course')
# router.register(r'group_levels', GroupLevelView, 'group_level')
# router.register(r'lessons', LessonViewSet, 'lesson')
router.register(r'lesson_assigns', LessonAssignmentViewSet, 'lesson_assignment')
# router.register(r'lesson_results', LessonResultViewSet, 'lesson_result')
# router.register(r'lesson_summary', LessonSummaryViewSet, 'lesson_summary')
router.register(r'news', NewsViewSet, 'news')
router.register(r'problems', ProblemViewSet, 'problem')
router.register(r'trains', MarkerViewSet, 'train')
# router.register(r'problem_meta', ProblemMetaViewSet, 'problem_meta')
router.register(r'resources', ResourceViewSet, 'resource')
# router.register(r'resource_tags', ResourceTagViewSet, 'resource_tag')
# router.register(r'skills', SkillListViewSet, 'skill')
router.register(r'subjects', SubjectListView, 'subject')
router.register(r'themes', ThemeListView, 'theme')
router.register(r'text_resources', TextResourceViewSet, 'text_resource')
router.register(r'content_types', ContentTypeViewSet, 'content_types')
# router.register(r'trainers_new', NewTrainerResultsViewSet, 'trainer_new')
router.register(r'users', UserViewSet, 'user')
router.register(r'activation_code', ActivationCodeViewSet, 'activation_code')
router.register(r'projects', ProjectViewSet, 'projects')
router.register(r'project_subjects', ProjectSubjectViewSet, 'project_subjects')
router.register(r'tags', TagViewSet, 'tags')
router.register(r'tag_types', TagTypeViewSet, 'tag_types')
router.register(r'assignment-rules/(?P<course_id>\d+)', AssignmentRuleViewSet, 'assigment_rules')
router.register(r'assignment-rule-triggers/(?P<rule_id>\d+)', AssignmentRuleTriggersViewSet, 'assigment_rule_triggers')

# API SIRIUS
router.register(r'sirius-courses', SiriusCourses, 'sirius-courses')
router.register(r'sirius-clesson', SiriusCLesson, 'sirius-clesson')
router.register(r'sirius-student-course-stat', SiriusStudentCourseStat, 'sirius-student-course-stat')
router.register(r'sirius-users', SiriusUserViewSet, 'sirius-users')

# API NEW ADMIN
router.register('admin/projects', ProjectViewSetAdmin, 'projects-admin')

router.register(r'study-groups', StudyGroupViewSet, 'study-groups')

# Upload
router.register(r'user_files', UserFilesPermissionViewSet, 'user_files')


# v3
simple_router_v3 = routers.SimpleRouter()

simple_router_v3.register(r'scorm-packages', ScormResourceUserDataViewSet)
scorm_package_router = routers.NestedSimpleRouter(simple_router_v3, r'scorm-packages', lookup='scorm_package')
scorm_package_router.register(r'resources', ScormResourceUserDataViewSet, base_name='resources')

simple_router_v3.register(r'courses', CourseStudentsViewSet)
course_students_router = routers.NestedSimpleRouter(simple_router_v3, r'courses', lookup='course')
course_students_router.register(r'students', CourseStudentsViewSet, base_name='course-students')
course_students_router.register(r'students_results', CourseStudentsResultsViewSet, base_name='course-students-results')

simple_router_v3.register(r'course', CourseViewSet3, 'course')
simple_router_v3.register(r'sirius-courses', SiriusCourses3, 'sirius-courses')

# url prefix with trailing '/'
API_URL_PREFIX = os.environ.get("API_URL_PREFIX", "")

v3_patterns = [
    url(r'', include(simple_router_v3.urls, namespace='v3')),
    url(r'', include(scorm_package_router.urls, namespace='v3-scorm-package')),
    url(r'', include(course_students_router.urls, namespace='v3-course-students')),

    # reports
    url(
        r'^course-reports/(?P<course_id>\d+)/requests/$',
        CourseReportRequestView.as_view(),
        name='v3-reports-course-reports-requests',
    ),
    url(r'^reports/requests/(?P<pk>\d+)/$', CourseReportRequestDetailView.as_view()),
    url(r'^reports/requests/(?P<pk>\d+)/result_data/$', CourseReportResultDataDetailView.as_view()),
    url(r'^reports/queries/$', QueryListAPIView.as_view()),
    url(r'^reports/queries/(?P<pk>\d+)/$', QueryDetailAPIView.as_view()),
    url(r'^reports/formats/$', ReportFormatAPIView.as_view()),

    url(r'course-invite', CourseInviteViewSet.as_view()),

    # profile
    url(r'^profile/', UserProfileView.as_view()),

    # player
    url(r'^player/', PlayerDataViewSet.as_view()),

    # reset results
    url(r'^results/$', ResetClessonResultsV3.as_view(), name='reset_clesson_results_v3'),

]


urlpatterns = [
    url(r'^ping/$', ping),
    url(r'^auth_ping/$', auth_ping, name='auth_ping'),
    url(r'^time/$', ping),  # все происходит в TimeMiddleware

    # метод для создания пользователя при первом заходе на наш сервис,
    # клиент попадает сюда через редирект в django_yauth
    url(r'^{}api/v2/create-user/$'.format(API_URL_PREFIX), use_master(create_profile),
        name=settings.YAUTH_CREATE_PROFILE_VIEW),
    # url(r'^api/v2/upload/', user_upload, name='user_upload'),
    url(r'^{}api/v2/'.format(API_URL_PREFIX), include(router.urls, namespace='v2')),
    url(r'^{}simple_upload/(.+)$'.format(API_URL_PREFIX), simple_upload),
    url(r'^{}api/v2/user-project/$'.format(API_URL_PREFIX),
        auto_add_to_project,
        name='auto_add_to_project'),
    url(r'^{}api/v2/user-project-course/(?P<project_id>\d+)/$'.format(API_URL_PREFIX),
        create_user_for_project,
        name='create_user_for_project'),
    url(r'^{}api/v2/takeout$'.format(API_URL_PREFIX), TakeoutView.as_view(), name="takeout-view"),
    url(r'^{}api/v2/achievery/'.format(API_URL_PREFIX), include(achievery_urls.urlpatterns)),
    url(r'^{}api/v2/idm/'.format(API_URL_PREFIX), include(idm_urls.urlpatterns)),

    # srv-api - API для сервисов, временно вынесено из под TVM Middleware
    url(r'^srv-api/v1/results/$'.format(API_URL_PREFIX), ResetClessonResults.as_view(), name='reset_clesson_results'),

    url(r'assignment-rule-edges/(?P<rule_id>\d+)/', AssignmentRuleEdgesViewSet.as_view(), name='clesson-edges'),
    url(r'assignment-rule-edge/(?P<edge_id>\d+)/', AssignmentRuleEdgeViewSet.as_view(), name='clesson-edges'),

    # v3 api
    url(r'^{}api/v3/'.format(API_URL_PREFIX), include(v3_patterns)),

    # idm
    url(r'^idm/', include('django_idm_api.urls')),

    url(r'^s3upload/', include('kelvin.common.s3upload.urls')),

    # урл отписки от рассылок
    # url(r'^unsubscribe/(?P<user_code>\w+)/$',
    #     unsubscribe_view,
    #     name='scheduled_email_unsubscribe'),
]

if settings.DEBUG:
    urlpatterns.append(url(r'^admin/', include(admin.site.urls)))

urlpatterns += static(settings.MEDIA_URL_SUFFIX,
                      document_root=settings.MEDIA_ROOT)

if settings.SILK_PROFILE:
    # интерфейс просмотра профилировки
    urlpatterns.append(url(r'^silk/', include('silk.urls', namespace='silk')))

urlpatterns += staticfiles_urlpatterns()


handler500 = 'kelvin.common.error_responses.server_error'
