"""
    Custom Test Assertions library
"""


PLACEHOLDER = "ZX_IGNORE"


def AssertDictsAreEqual(actual, expected, message=""):
    """
    :param actual: actual dict received from the SUT
    :param expected: dict with expectations which
    could be scalars or simple prediction functions
    ( example: lambda x: re.match(r/^http:.*$/, x) -
    - this one predict value starts with 'http:'
    :return: calls standart assert per each key it faced with
    """
    for key_to_test in expected.keys():
        if type(expected[key_to_test]) is dict:
            AssertDictsAreEqual(actual[key_to_test],
                                expected[key_to_test], message)
        elif type(expected[key_to_test]) is list:
            assert len(
                actual[key_to_test]
            ) == len(
                expected[key_to_test]
            ), "{0}. key {1} len differs".format(message, key_to_test)
            for i in range(0, len(expected[key_to_test])):
                AssertDictsAreEqual(
                    actual[key_to_test][i], expected[key_to_test][i], message)
        elif callable(expected[key_to_test]):
            assert expected[key_to_test](actual[key_to_test]) is True, \
                "{0}. key {1}".format(
                message, key_to_test)
        else:
            assert expected[key_to_test] == actual[key_to_test], \
                "{0}. Key {1}".format(
                message, key_to_test)


def AssertDictsAreStrictEqual(actual, expected, except_keys=[], message=u""):
    """
    Assertion to check two dict for strict equality with ability
    to ignore keys from comparision
    """

    for except_key in except_keys:
        actual[except_key] = expected[except_key] = PLACEHOLDER

    assert actual == expected, message


def AssertListsAreSemanticallyEqual(lhs, rhs):
    """
    Compares to lists are semantically equal
    :param lhs: left-side list to compare
    :param rhs: right-side list to compare
    :return: True if lhs contains the same elements as rhs does ( order is ignoring )

    :example 1: lhs=[1,2,3], rhs=[2,3,1] , result: True
    :example 2: lhs=[1,2,3,4], rhs=[2,3,1] , result: False
    """
    assert set(lhs) == set(rhs)
