#!/bin/bash

set -o pipefail

echo "Check imports..."
isort --recursive --check-only --diff --skip-glob */migrations/* --skip-glob media --line-width 120 src

echo "Django check..."
python src/manage.py check

echo "Check migrations..."
python src/manage.py makemigrations --dry-run --check

echo "Test..."
pytest ./src ./integration_tests -v