#!/usr/bin/env python

import argparse
import socket
import sys
import time


def wait_for_port(host, port, sleep=None, retries=None, timeout=None):
    for _ in range(0, retries):
        try:
            sock = socket.create_connection((host, port), timeout=timeout)
            sock.close()
            print(f"{host}:{port} is available")
            return True
        except (socket.timeout, socket.error) as e:
            print(f"{host}:{port} unavailable: {e}")
            time.sleep(sleep)
    return False


def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("host", help="Domain name or IP adress")
    parser.add_argument("port", type=int, help="Port number")
    parser.add_argument("-s", "--sleep", default=2, dest="sleep", type=float, help="Seconds to sleep between retries")
    parser.add_argument("-r", "--retries", default=3, dest="retries", type=int, help="How many times to retry")
    parser.add_argument("-t", "--timeout", default=10, dest="timeout", type=int, help="Timeout waiting for port")
    args = parser.parse_args()

    host = args.host
    port = args.port
    sleep = args.sleep
    retries = args.retries
    timeout = args.timeout

    if wait_for_port(host=host, port=port, sleep=sleep, retries=retries, timeout=timeout):
        sys.exit(0)

    sys.exit(1)


if __name__ == "__main__":
    main()
