# coding: utf-8

from __future__ import unicode_literals

import json
import os
import socket
import struct
from contextlib import contextmanager
from typing import Dict, Tuple, Union


socket_path = os.getenv('SOCKET_PATH', '/socket.sock')


class Connection(object):
    def __init__(self, sock=None, autoconnect=True):
        if not sock:
            sock = socket.socket(socket.AF_UNIX, socket.SOCK_STREAM)
        self.socket = sock
        if autoconnect:
            self.socket.connect(socket_path)

    def send_data(self, response_code: Union[int, Dict], data: Dict = None) -> None:
        if not data:
            # for compatibility with idm.yandex-team.ru
            # idm uses response code, ok-flow don't
            data = response_code
            response_code = 0
        encoded_data = json.dumps(data).encode('utf-8', 'strict')
        header = struct.pack('<LL', response_code, len(encoded_data))
        self.socket.sendall(header+encoded_data)

    def _recvall(self, response_length):
        data = b''
        to_get = response_length
        while to_get:
            new_data = self.socket.recv(to_get)
            data += new_data
            to_get -= len(new_data)
        return data

    def get_data(self) -> Tuple[int, Dict]:
        response_length_data = self._recvall(8)
        response_code, response_length = struct.unpack('<LL', response_length_data)
        raw_response_data = self._recvall(response_length)
        response_data = raw_response_data.decode()
        response = json.loads(response_data)
        return response_code, response

    def close(self):
        self.socket.close()


@contextmanager
def get() -> Connection:
    connect = Connection()
    try:
        yield connect
    finally:
        connect.close()

