from django.urls import path

from . import views


urlpatterns = [
    path(
        '',
        views.ApprovementView.as_view({
            'get': 'list',
            'post': 'create',
        }),
        name='list-create',
    ),
    path(
        '<uuid:uuid>/',
        views.ApprovementView.as_view({
            'get': 'retrieve',
        }),
        name='detail',
    ),
    path(
        'gap_newhire_counts/',
        views.GapNewhireCountsView.as_view(),
        name='gap-newhire-counts',
    ),
    path(
        '_validate/',
        views.ApprovementView.as_view({'post': 'validate_for_create'}),
        name='create-validate',
    ),
    path(
        '_form/',
        views.ApprovementView.as_view(is_form_view=True, actions={
            'get': 'create_form',
        }),
        name='create-form',
    ),
    path(
        '_filter_form/',
        views.ApprovementListFilterFormView.as_view({
            'get': 'create_form',
        }),
        name='filter-form',
    ),
    path(
        'for_responsibles/',
        views.ApprovementForResponsiblesListView.as_view({
            'get': 'list',
        }),
        name='responsibles-list',
    ),
    path(
        'for_responsibles/_filter_form/',
        views.ApprovementForResponsiblesListView.as_view({
            'get': 'create_form',
        }),
        name='responsibles-list-filter-form',
    ),
    path(
        'check/',
        views.ApprovementCheckView.as_view(),
        name='check',
    ),
    path(
        '<uuid:uuid>/edit/',
        views.ApprovementEditView.as_view({
            'put': 'perform_action',
        }),
        name='edit',
    ),
    path(
        '<uuid:uuid>/approve/',
        views.ApprovementApproveView.as_view(),
        name='approve',
    ),
    path(
        '<uuid:uuid>/approve/_form/',
        views.ApprovementApproveView.as_form_view(),
        name='approve-form',
    ),
    path(
        '<uuid:uuid>/reject/',
        views.ApprovementRejectView.as_view(),
        name='reject',
    ),
    path(
        '<uuid:uuid>/reject/_form/',
        views.ApprovementRejectView.as_form_view(),
        name='reject-form',
    ),
    path(
        '<uuid:uuid>/suspend/',
        views.ApprovementWorkflowView.as_view(action_name='suspend'),
        name='suspend',
    ),
    path(
        '<uuid:uuid>/resume/',
        views.ApprovementWorkflowView.as_view(action_name='resume'),
        name='resume',
    ),
    path(
        '<uuid:uuid>/close/',
        views.ApprovementWorkflowView.as_view(action_name='close'),
        name='close',
    ),
    path(
        'possible_disapproval_reasons/',
        views.ApprovementDisapprovalReasonsView.as_view(),
        name='possible-disapproval-reasons',
    )
]
