from rest_framework import serializers
from rest_framework.fields import ReadOnlyField


class SlugNameSerializer(serializers.Serializer):

    slug = serializers.ReadOnlyField()
    name = serializers.ReadOnlyField()


class WorkflowActionsField(ReadOnlyField):

    def __init__(self, workflow_class=None, **kwargs):
        self.workflow_class = workflow_class
        kwargs['source'] = '*'
        super().__init__(**kwargs)

    def to_representation(self, value):
        user = self.root.context.get('user')
        if user:
            return self.workflow_class(
                instance=value,
                user=user.login,
            ).get_actions()
        return {}
