from ok.api.core.errors import SimpleValidationError
from ok.staff.models import Group


def clean_staff_groups(groups, group_urls=None):
    if not groups and not group_urls:
        return groups
    if not group_urls:
        group_urls = {group.url for group in groups}
    existing_group_urls = {
        group.url
        for group in groups
        if not group.is_deleted and group.staff_id is not None
    }
    if group_urls != existing_group_urls:
        raise SimpleValidationError(
            code='group_does_not_exist',
            params={'groups': list(group_urls - existing_group_urls)},
        )
    return list(groups)


def clean_staff_group_urls(group_urls):
    if not group_urls:
        return group_urls
    group_urls = {g.strip().lower() for g in group_urls}
    groups = Group.objects.filter(url__in=group_urls)
    cleaned_groups = clean_staff_groups(groups, group_urls)
    return [group.url for group in cleaned_groups]
