from django.urls import path

from . import views


urlpatterns = [
    path(
        '',
        views.ScenarioListCreateView.as_view({
            'get': 'list',
            'post': 'create',
        }),
        name='list-create',
    ),
    path(
        '_validate/',
        views.ScenarioListCreateView.as_view({'post': 'validate_for_create'}),
        name='create-validate',
    ),
    path(
        '_form/',
        views.ScenarioListCreateView.as_view({
            'get': 'create_form',
        }),
        name='create-form',
    ),
    path(
        '_filter_form/',
        views.ScenarioListFilterFormView.as_view({
            'get': 'create_form',
        }),
        name='filter-form',
    ),
    path(
        '<slug:slug>/',
        views.ScenarioDetailView.as_view({
            'get': 'retrieve',
            'put': 'perform_action',
        }),
        name='detail',
    ),
    path(
        '<slug:slug>/_form/',
        views.ScenarioDetailView.as_form_view(),
        name='update-form',
    ),
    path(
        '<slug:slug>/clone/_form/',
        views.ScenarioCloneFormView.as_view({
            'get': 'update_form',
        }),
        name='clone-form',
    ),
    path(
        '<slug:slug>/archive/',
        views.ScenarioWorkflowView.as_view(action_name='archive'),
        name='archive',
    ),
    path(
        '<slug:slug>/restore/',
        views.ScenarioWorkflowView.as_view(action_name='restore'),
        name='restore',
    ),
]
