from logging import getLogger

from startrek_client.exceptions import NotFound, StartrekError, Forbidden

from ok.api.core.errors import SimpleValidationError
from ok.tracker.base import QUEUE_KEY_RE, get_user_tracker_client
from ok.utils.attrs import get_attribute


logger = getLogger(__name__)


def _get_queue(key):
    client = get_user_tracker_client()
    try:
        return client.queues[key]
    # Информация об очереди доступна всем, но Трекер отдаёт 403, если очередь удалена
    except (NotFound, Forbidden):
        raise SimpleValidationError('queue_does_not_exist')
    except StartrekError as exc:
        logger.warning('Could not get queue %s', key, exc_info=exc)
        raise SimpleValidationError('startrek_error')


def validate_user_can_setup_queue(key):
    is_valid_key = bool(QUEUE_KEY_RE.match(key))
    if not is_valid_key:
        raise SimpleValidationError('invalid')
    queue = _get_queue(key)
    try:
        # Есть отдельная ручка checkPermissions, но в библиотеке она работает странно,
        # поэтому просто пытаемся получить права очереди. Если это сделать нельзя,
        # то считаем, что права настраивать очередь нет
        queue.permissions
    except Forbidden:
        raise SimpleValidationError(
            code='permission_denied',
            params={'owner': get_attribute(queue, 'lead.id')},
        )
    except StartrekError as exc:
        logger.warning('Could not get queue permissions %s', key, exc_info=exc)
        raise SimpleValidationError('startrek_error')
