import uuid
import yenv

from django.utils.decorators import method_decorator
from django.views.decorators.csrf import ensure_csrf_cookie
from rest_framework import status
from rest_framework.response import Response
from waffle.models import Switch

from ok.api.core.views import BaseView


@method_decorator(ensure_csrf_cookie, 'dispatch')
class MetaView(BaseView):

    def get(self, request, *args, **kwargs):
        # OK-510: Добавляю сюда на всякий случай, но лучше это генерить на стороне браузера.
        # Пока считаем, что если фронт нам его передал, возвращаем обратно, если нет – генерим
        ok_session_id = request.headers.get('x-ok-session-id') or str(uuid.uuid4())

        data = {
            'environment': yenv.type,
            'waffle': {
                'switches': {s.name: s.active for s in Switch.get_all()},
            },
            'user': {
                'login': request.yauser.login,
                'uid': request.yauser.uid,
                'language': request.yauser.language,
            },
            'ok_session_id': ok_session_id,
        }
        return Response(data, status=status.HTTP_200_OK)
