from django.utils.translation import ugettext_lazy, ugettext_noop as _
from model_utils import Choices


APPROVEMENT_TYPES = Choices(
    ('general', _('approvement.type.general')),
    ('tracker', _('approvement.type.tracker')),
)

APPROVEMENT_STATUSES = Choices(
    ('in_progress', _('approvement.status.in_progress')),
    ('suspended', _('approvement.status.suspended')),
    ('rejected', _('approvement.status.rejected')),
    ('closed', _('approvement.status.closed')),
)

APPROVEMENT_RESOLUTIONS = Choices(
    ('approved', _('approvement.resolution.approved')),
    ('declined', _('approvement.resolution.declined')),
)

APPROVEMENT_ROLES = Choices(
    ('author', _('approvement.role.author')),
    ('responsible', _('approvement.role.responsible')),
    ('approver', _('approvement.role.approver')),
)

APPROVEMENT_SORTING_TYPES = Choices(
    ('modified', 'modified_asc', _('approvement.sorting.modified_asc')),
    ('-modified', 'modified_desc', _('approvement.sorting.modified_desc')),
)

APPROVEMENT_STAGE_ACTIVE_STATUSES = Choices(
    ('pending', _('approvement_stage.status.pending')),
    ('current', _('approvement_stage.status.current')),
)

APPROVEMENT_STAGE_STATUSES = APPROVEMENT_STAGE_ACTIVE_STATUSES + Choices(
    ('suspended', _('approvement_stage.status.suspended')),
    ('approved', _('approvement_stage.status.approved')),
    ('rejected', _('approvement_stage.status.rejected')),
    ('cancelled', _('approvement_stage.status.cancelled')),
)

APPROVEMENT_STAGE_FINISHED_STATUS_SET = {
    APPROVEMENT_STAGE_STATUSES.approved,
    APPROVEMENT_STAGE_STATUSES.rejected,
    APPROVEMENT_STAGE_STATUSES.cancelled,
}

APPROVEMENT_STAGE_APPROVEMENT_SOURCES = Choices(
    ('api', _('approvement_stage.approvement_source.api')),
    ('comment', _('approvement_stage.approvement_source.comment')),
)

APPROVEMENT_HISTORY_EVENTS = Choices(
    ('status_changed', _('approvement_history.event.status_changed')),
    ('ping_sent', _('approvement_history.event.ping_sent')),
    ('question_asked', _('approvement_history.event.question_asked')),
    ('approver_changed', _('approvement_history.approver_changed'))
)

APPROVEMENT_STATUS_TRACKER_MAPPING = {
    APPROVEMENT_STATUSES.in_progress: 'Запущено',
    APPROVEMENT_STATUSES.suspended: 'Приостановлено',
    APPROVEMENT_STATUSES.rejected: 'Приостановлено',
}

APPROVEMENT_RESOLUTION_TRACKER_MAPPING = {
    APPROVEMENT_RESOLUTIONS.approved: 'Согласовано',
    APPROVEMENT_RESOLUTIONS.declined: 'Отменено',
}

POSSIBLE_DISAPPROVAL_REASONS = Choices(
    ('wont_fix', ugettext_lazy("Won't fix")),
    ('no_budget', ugettext_lazy('No budget')),
    ('duplicate', ugettext_lazy('Duplicate')),
    ('refused', ugettext_lazy('Refused')),
    ('postponed', ugettext_lazy('Postponed')),
    ('canceled', ugettext_lazy('Canceled')),
    ('not_relevant', ugettext_lazy('Not relevant')),
)
