from django.core.management import BaseCommand
from django.utils import timezone

from ok.approvements.models import ApprovementHistory
from ok.approvements.yt.tables import YTApprovementHistoryTable
from ok.utils.datetime import get_beginning_of_moscow_day


class Command(BaseCommand):

    help = 'Save approvement history in YT'

    def handle(self, *args, **options):
        today = get_beginning_of_moscow_day(timezone.now())
        history_entries = ApprovementHistory.objects.filter(created__lt=today)
        chunk_size = 1000
        chunks = (
            history_entries[start:start + chunk_size]
            for start in range(0, history_entries.count(), chunk_size)
        )

        table = YTApprovementHistoryTable()
        table.create(ignore_existing=True)

        for i, chunk in enumerate(chunks, 1):
            table.write(chunk)
            print(f'{i * chunk_size} history entries are saved in YT')
