# Generated by Django 2.1.4 on 2018-12-11 13:18

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields

import ok.approvements.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Approvement',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('author', models.CharField(max_length=255)),
                ('text', models.CharField(max_length=255)),
                ('status', models.CharField(
                    choices=[
                        ('in_progress', 'approvement.status.in_progress'),
                        ('suspended', 'approvement.status.suspended'),
                        ('rejected', 'approvement.status.rejected'),
                        ('closed', 'approvement.status.closed'),
                    ],
                    default='in_progress',
                    max_length=32,
                )),
                ('resolution', models.CharField(choices=[('approved', 'approvement.resolution.approved'), ('declined', 'approvement.resolution.declined')], max_length=32, null=True)),
                ('uid', models.CharField(
                    default=ok.approvements.models._uuid_hex,
                    help_text=(
                        'Идентификатор согласования, псевдо-уникальный в рамках объекта согласования. '
                        'Например, таким образом мы различаем два согласования в рамках одного тикета. '
                        'По факту, это чаще всего захэшированные дата и время'
                    ),
                    max_length=32,
                )),
                ('object_id', models.CharField(max_length=32)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ApprovementStage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('approver', models.CharField(blank=True, max_length=255, help_text='Кто должен поставить "ок"',)),
                ('is_approved', models.NullBooleanField()),
                ('position', models.IntegerField()),
                ('approvement', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='stages', to='approvements.Approvement')),
            ],
            options={
                'abstract': False,
                'ordering': ['position'],
            },
        ),
    ]
