# Generated by Django 2.2.5 on 2019-10-07 13:19
import time

from django.db import migrations, models, transaction


def get_next_stages(approvement):
    stages = approvement.stages.filter(status='pending')
    if approvement.is_parallel:
        return stages
    first_stage = stages.first()
    if not first_stage:
        return approvement.stages.none()
    q = models.Q(id=first_stage.id)
    if first_stage.approver == '':
        q |= models.Q(parent=first_stage)
    return stages.filter(q)


def set_stage_status_current(apps, schema_editor):
    Approvement = apps.get_model('approvements', 'Approvement')
    ApprovementStage = apps.get_model('approvements', 'ApprovementStage')
    pending_stages = ApprovementStage.objects.filter(status='pending')
    current_stages = ApprovementStage.objects.filter(status='current')
    queryset = (
        Approvement.objects
        .filter(status='in_progress')
        .filter(id__in=pending_stages.values('approvement_id'))
        .exclude(id__in=current_stages.values('approvement_id'))
    )

    chunk_size = 100
    while queryset.exists():
        with transaction.atomic():
            approvements = list(queryset.select_for_update(skip_locked=True)[:chunk_size])
            approvement_ids = [i.id for i in approvements]
            # Блокируем все стадии согласования на время транзакции
            ApprovementStage.objects.filter(approvement_id__in=approvement_ids).select_for_update()
            for approvement in approvements:
                next_stages = get_next_stages(approvement)
                next_stages.update(status='current')
        # Немного ждём, на случай если есть заблокированные строки
        if not approvement_ids:
            time.sleep(5)


class Migration(migrations.Migration):

    atomic = False

    dependencies = [
        ('approvements', '0030_approvementstage_is_with_deputies'),
    ]

    operations = [
        migrations.RunPython(set_stage_status_current, migrations.RunPython.noop, atomic=False),
    ]
